@extends('backend.layouts.app')

@section('content')
    <!-- GST  -->
    <div class="card">
        <div class="card-header">
            <h5 class="mb-0 h6">{{ translate('Business Settings') }}</h5>
        </div>

        <div class="card-body">
            <form action="{{ route('business_info.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                @if (addon_is_activated('gst_system'))
                {{-- GSTIN Number --}}
                <div class="row">
                    <div class="col-md-2">
                        <label>
                            {{ translate('GSTIN Number') }}
                            <span class="text-danger">*</span>
                        </label>
                    </div>
                    <div class="col-md-10">
                        <input type="text" class="form-control mb-3"  name="gstin_number" placeholder="{{ translate('GSTIN Number') }}" value="{{ $business_info['gstin'] ?? '' }}" required>
                    </div>
                </div>

                {{-- GSTIN Certificate --}}
                <div class="row">
                    <div class="col-md-2">
                        <label>
                            {{ translate('GSTIN Certificate') }}
                            <span class="text-danger">*</span>
                        </label>
                    </div>
                    <div class="col-md-10">
                        <div class="custom-file mb-3">
                            <label class="custom-file-label">
                                <input type="file" class="custom-file-input preview-input" data-preview="#gst_preview" name="gstin_certificate" id="gstin_certificate"  accept=".jpg,.jpeg,.png,.bmp,application/pdf" required>
                                <span class="custom-file-name">{{ translate('Choose file') }}</span>
                            </label>
                        </div>
                        <div id="gst_preview" class="mt-2"></div>
                        @if (isset($business_info['gstin_certificate']))
                        <div class="mb-2 text-center">
                            <a onclick="showFileInModal('{{ my_asset($business_info['gstin_certificate']) }}')" class="btn btn-sm btn-info text-white">{{ translate('View Current Certificate') }}</a>
                        </div>
                        @endif
                    </div>
                </div>
                @endif

                {{-- Certificate Number --}}
                <div class="row">
                    <div class="col-md-2">
                        <label>
                            {{ translate('VAT / TIN / BIN Number') }}
                        </label>
                    </div>
                    <div class="col-md-10">
                        <input type="text"  class="form-control mb-3"  name="certificate_number" placeholder="{{ translate('VAT / TIN / BIN Number') }}" value="{{ $business_info['certificate_number'] ?? '' }}">
                    </div>
                </div>

                {{-- Certificate --}}
                <div class="row">
                    <div class="col-md-2">
                        <label>
                            {{ translate('Reg Certificate / Trade License / Sale Tax Permit ') }}
                        </label>
                    </div>
                    <div class="col-md-10">
                        <div class="custom-file mb-3">
                            <label class="custom-file-label">
                                <input type="file" class="custom-file-input preview-input" data-preview="#certificate_preview" name="certificate" id="certificate"  accept=".jpg,.jpeg,.png,.bmp,application/pdf" >
                                <span class="custom-file-name">{{ translate('Choose file') }}</span>
                            </label>
                        </div>
                        <div id="certificate_preview" class="mt-2"></div>
                        @if (isset($business_info['certificate']))
                        <div class="mb-2 text-center">
                            <a onclick="showFileInModal('{{ my_asset($business_info['certificate']) }}')" class="btn btn-sm btn-info text-white">{{ translate('View Current Certificate') }}</a>
                        </div>
                        @endif
                    </div>
                </div>

                @if (get_active_countries()->count() >1)
                <div class="row">
                    <div class="col-md-2">
                        <label>{{ translate('Country')}} <span class="text-danger">*</span></label>
                    </div>
                    <div class="col-md-10">
                        <div class="mb-3">
                            <select class="form-control aiz-selectpicker" data-live-search="true" data-placeholder="{{ translate('Select your country') }}" name="country_id" required>
                                <option value="">{{ translate('Select your country') }}</option>
                                @foreach (\App\Models\Country::where('status', 1)->get() as $key => $country)
                                <option value="{{ $country->id }}" @if(isset($business_info['country']) && $business_info['country'] == $country->name) selected @endif>{{ $country->name }} </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                @elseif(get_active_countries()->count() == 1)
                <input type="hidden" name="country_id" value="{{ get_active_countries()->first()->id }}">
                @endif
                <div class="row">
                    <div class="col-md-2">
                        <label>{{ translate('State')}} <span class="text-danger">*</span></label>
                    </div>
                    <div class="col-md-10">
                        <select class="form-control mb-3 aiz-selectpicker" data-live-search="true" name="state_id" required>

                        </select>
                    </div>
                </div>
                <div class="form-group mt-3 mb-0 text-right">
                    <button type="submit" class="btn btn-sm btn-primary">
                        {{ translate('Save') }}
                    </button>
                </div>

            </form>
        </div>
    </div>
@endsection

@section('modal')
<div class="modal fade" id="filePreviewModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">{{translate('File Preview')}}</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body" style="min-height: 500px;">
        <div id="filePreviewContainer" class="text-center"></div>
      </div>
    </div>
  </div>
</div>

@endsection

@section('script')

 <script>
    $(document).on('change', '[name=country_id]', function() {
        var country_id = $(this).val();
        get_states(country_id);
    });

    $(document).ready(function() {
        var country_id = $('[name=country_id]').val();
        get_states(country_id);
    });

    function get_states(country_id) {
        var savedStateName = "{{ $business_info['state'] ?? '' }}";
        var stateSelect = $('[name="state_id"]');
        $('[name="state"]').html("");
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            url: "{{route('admin.get-state')}}",
            type: 'POST',
            data: {
                country_id: country_id
            },
            success: function(response) {
                var obj = JSON.parse(response);
                if (obj != '') {
                    $('[name="state_id"]').html(obj);
                    if (savedStateName) {
                    stateSelect.find('option').each(function() {
                        if ($(this).text().trim() === savedStateName.trim()) {
                            $(this).prop('selected', true);
                        }
                    });
                }
                    AIZ.plugins.bootstrapSelect('refresh');
                }
            }
        });
    }

    function showFileInModal(fileUrl) {
        const ext = fileUrl.split('.').pop().toLowerCase();
        const container = document.getElementById('filePreviewContainer');
        container.innerHTML = '';

        if (['jpg', 'jpeg', 'png', 'gif', 'webp'].includes(ext)) {
            const img = document.createElement('img');
            img.src = fileUrl;
            img.style.maxWidth = '100%';
            img.style.maxHeight = '600px';
            container.appendChild(img);
        } else if (ext === 'pdf') {
            const iframe = document.createElement('iframe');
            iframe.src = fileUrl;
            iframe.style.width = '100%';
            iframe.style.height = '600px';
            iframe.frameBorder = 0;
            container.appendChild(iframe);
        } else {
            container.innerHTML = '<p class="text-danger">Unsupported file format.</p>';
        }

        $('#filePreviewModal').modal('show');
    }

    $(document).on('change', '.preview-input', function () {
        let input = this;
        let previewBox = $($(this).data('preview'));
        let fileName = input.files[0]?.name || '';

        $(this).next('.custom-file-label').html(fileName);

        previewBox.html('');

        if (input.files && input.files[0]) {
            let file = input.files[0];
            let fileType = file.type;
            if (fileType.startsWith('image/')) {
                let reader = new FileReader();
                reader.onload = function (e) {
                    previewBox.html(
                        '<img src="' + e.target.result + '" class="preview-img img-fluid h-100px w-100-px">'
                    );
                };
                reader.readAsDataURL(file);
            }
            else if (fileType === 'application/pdf') {
                previewBox.html(`
                    <div class="pdf-preview d-flex align-items-end justify-content-center border rounded text-center" 
                        style="width:100px; height:100px; background-color:#f8f9fa; position:relative; font-size:40px; color:#e74c3c;">
                        <i class="las la-file-pdf" style="position:absolute; top:50%; left:50%; transform:translate(-50%, -50%); opacity:0.2; font-size:50px;"></i>
                        <small class="text-truncate-1 fs-10" style="position:absolute; bottom:5px; left:0;" title="${fileName}">${fileName}</small>
                    </div>
                `);
            }
        }
    });

    </script>


    @if(get_active_countries()->count() == 1)
    <script>
        $(document).ready(function() {
            get_states(@json(get_active_countries()[0]->id))
        });
    </script>
    @endif
   
@endsection
